/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_finalize.c,v 1.28 2006/07/14 14:38:16 bgoglin Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__internals.h"
#include "mx__error.h"
#include "mx__debug_dump.h"
#include "mx__endpoint.h"

MX_FUNC(mx_return_t)
mx_finalize(void)
{
  mx_return_t ret = MX_SUCCESS;

  MX__MUTEX_LOCK(MX_LOCK);

  if (Mx_init_count == 0) {
    ret = mx__error_noep("mx_finalize", MX_NOT_INITIALIZED);
    goto out_locked;
  }

#ifndef MX_KERNEL
  if (Mx_endpoints) {
    MX_WARN(("mx_finalize() called while some endpoints are still open.\n"));
    ret = mx__error_noep("mx_finalize", MX_BUSY);
    goto out_locked;
  }
#endif

  --Mx_init_count;
#ifndef MX_KERNEL
  if (Mx_init_count == 0) {
    mx__finalize_signal_handling();
  }
#endif

 out_locked:
  MX__MUTEX_UNLOCK(MX_LOCK);
  return ret;
}
